package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{IamRoleArn, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobDetailsEntity(
    jobId: JobId,
    jobAttachmentSettings: Optional[
      zio.aws.deadline.model.JobAttachmentSettings
    ] = Optional.Absent,
    jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser] =
      Optional.Absent,
    logGroupName: String,
    queueRoleArn: Optional[IamRoleArn] = Optional.Absent,
    parameters: Optional[Map[String, zio.aws.deadline.model.JobParameter]] =
      Optional.Absent,
    schemaVersion: String,
    pathMappingRules: Optional[
      Iterable[zio.aws.deadline.model.PathMappingRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobDetailsEntity = {
    import JobDetailsEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobDetailsEntity
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        jobAttachmentSettings.map(value => value.buildAwsValue())
      )(_.jobAttachmentSettings)
      .optionallyWith(jobRunAsUser.map(value => value.buildAwsValue()))(
        _.jobRunAsUser
      )
      .logGroupName(logGroupName: java.lang.String)
      .optionallyWith(
        queueRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.queueRoleArn)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .schemaVersion(schemaVersion: java.lang.String)
      .optionallyWith(
        pathMappingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pathMappingRules)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobDetailsEntity.ReadOnly =
    zio.aws.deadline.model.JobDetailsEntity.wrap(buildAwsValue())
}
object JobDetailsEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobDetailsEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobDetailsEntity =
      zio.aws.deadline.model.JobDetailsEntity(
        jobId,
        jobAttachmentSettings.map(value => value.asEditable),
        jobRunAsUser.map(value => value.asEditable),
        logGroupName,
        queueRoleArn.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        schemaVersion,
        pathMappingRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobId: JobId
    def jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly]
    def jobRunAsUser: Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly]
    def logGroupName: String
    def queueRoleArn: Optional[IamRoleArn]
    def parameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]]
    def schemaVersion: String
    def pathMappingRules
        : Optional[List[zio.aws.deadline.model.PathMappingRule.ReadOnly]]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getJobAttachmentSettings: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.JobAttachmentSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("jobAttachmentSettings", jobAttachmentSettings)
    def getJobRunAsUser
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      AwsError.unwrapOptionField("jobRunAsUser", jobRunAsUser)
    def getLogGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(logGroupName)
    def getQueueRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("queueRoleArn", queueRoleArn)
    def getParameters: ZIO[Any, AwsError, Map[
      String,
      zio.aws.deadline.model.JobParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getPathMappingRules: ZIO[Any, AwsError, List[
      zio.aws.deadline.model.PathMappingRule.ReadOnly
    ]] = AwsError.unwrapOptionField("pathMappingRules", pathMappingRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobDetailsEntity
  ) extends zio.aws.deadline.model.JobDetailsEntity.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val jobAttachmentSettings
        : Optional[zio.aws.deadline.model.JobAttachmentSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobAttachmentSettings())
        .map(value => zio.aws.deadline.model.JobAttachmentSettings.wrap(value))
    override val jobRunAsUser
        : Optional[zio.aws.deadline.model.JobRunAsUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobRunAsUser())
        .map(value => zio.aws.deadline.model.JobRunAsUser.wrap(value))
    override val logGroupName: String = impl.logGroupName(): String
    override val queueRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.queueRoleArn())
      .map(value => zio.aws.deadline.model.primitives.IamRoleArn(value))
    override val parameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.deadline.model.JobParameter.wrap(value)
            })
            .toMap
        )
    override val schemaVersion: String = impl.schemaVersion(): String
    override val pathMappingRules
        : Optional[List[zio.aws.deadline.model.PathMappingRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathMappingRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.PathMappingRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobDetailsEntity
  ): zio.aws.deadline.model.JobDetailsEntity.ReadOnly = new Wrapper(impl)
}
