package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobDetailsIdentifiers(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobDetailsIdentifiers = {
    import JobDetailsIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobDetailsIdentifiers
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobDetailsIdentifiers.ReadOnly =
    zio.aws.deadline.model.JobDetailsIdentifiers.wrap(buildAwsValue())
}
object JobDetailsIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobDetailsIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobDetailsIdentifiers =
      zio.aws.deadline.model.JobDetailsIdentifiers(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobDetailsIdentifiers
  ) extends zio.aws.deadline.model.JobDetailsIdentifiers.ReadOnly {
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobDetailsIdentifiers
  ): zio.aws.deadline.model.JobDetailsIdentifiers.ReadOnly = new Wrapper(impl)
}
