package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobEntity(
    jobDetails: Optional[zio.aws.deadline.model.JobDetailsEntity] =
      Optional.Absent,
    jobAttachmentDetails: Optional[
      zio.aws.deadline.model.JobAttachmentDetailsEntity
    ] = Optional.Absent,
    stepDetails: Optional[zio.aws.deadline.model.StepDetailsEntity] =
      Optional.Absent,
    environmentDetails: Optional[
      zio.aws.deadline.model.EnvironmentDetailsEntity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobEntity = {
    import JobEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobEntity
      .builder()
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(jobAttachmentDetails.map(value => value.buildAwsValue()))(
        _.jobAttachmentDetails
      )
      .optionallyWith(stepDetails.map(value => value.buildAwsValue()))(
        _.stepDetails
      )
      .optionallyWith(environmentDetails.map(value => value.buildAwsValue()))(
        _.environmentDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobEntity.ReadOnly =
    zio.aws.deadline.model.JobEntity.wrap(buildAwsValue())
}
object JobEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobEntity =
      zio.aws.deadline.model.JobEntity(
        jobDetails.map(value => value.asEditable),
        jobAttachmentDetails.map(value => value.asEditable),
        stepDetails.map(value => value.asEditable),
        environmentDetails.map(value => value.asEditable)
      )
    def jobDetails: Optional[zio.aws.deadline.model.JobDetailsEntity.ReadOnly]
    def jobAttachmentDetails
        : Optional[zio.aws.deadline.model.JobAttachmentDetailsEntity.ReadOnly]
    def stepDetails: Optional[zio.aws.deadline.model.StepDetailsEntity.ReadOnly]
    def environmentDetails
        : Optional[zio.aws.deadline.model.EnvironmentDetailsEntity.ReadOnly]
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobDetailsEntity.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getJobAttachmentDetails: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.JobAttachmentDetailsEntity.ReadOnly
    ] = AwsError.unwrapOptionField("jobAttachmentDetails", jobAttachmentDetails)
    def getStepDetails: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.StepDetailsEntity.ReadOnly
    ] = AwsError.unwrapOptionField("stepDetails", stepDetails)
    def getEnvironmentDetails: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.EnvironmentDetailsEntity.ReadOnly
    ] = AwsError.unwrapOptionField("environmentDetails", environmentDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobEntity
  ) extends zio.aws.deadline.model.JobEntity.ReadOnly {
    override val jobDetails
        : Optional[zio.aws.deadline.model.JobDetailsEntity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value => zio.aws.deadline.model.JobDetailsEntity.wrap(value))
    override val jobAttachmentDetails
        : Optional[zio.aws.deadline.model.JobAttachmentDetailsEntity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobAttachmentDetails())
        .map(value =>
          zio.aws.deadline.model.JobAttachmentDetailsEntity.wrap(value)
        )
    override val stepDetails
        : Optional[zio.aws.deadline.model.StepDetailsEntity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepDetails())
        .map(value => zio.aws.deadline.model.StepDetailsEntity.wrap(value))
    override val environmentDetails
        : Optional[zio.aws.deadline.model.EnvironmentDetailsEntity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentDetails())
        .map(value =>
          zio.aws.deadline.model.EnvironmentDetailsEntity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobEntity
  ): zio.aws.deadline.model.JobEntity.ReadOnly = new Wrapper(impl)
}
