package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait JobEntityErrorCode {
  def unwrap: software.amazon.awssdk.services.deadline.model.JobEntityErrorCode
}
object JobEntityErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.JobEntityErrorCode
  ): zio.aws.deadline.model.JobEntityErrorCode = value match {
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.ACCESS_DENIED_EXCEPTION =>
      val r = AccessDeniedException
      r
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.INTERNAL_SERVER_EXCEPTION =>
      val r = InternalServerException
      r
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.VALIDATION_EXCEPTION =>
      val r = ValidationException
      r
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.RESOURCE_NOT_FOUND_EXCEPTION =>
      val r = ResourceNotFoundException
      r
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.MAX_PAYLOAD_SIZE_EXCEEDED =>
      val r = MaxPayloadSizeExceeded
      r
    case software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.CONFLICT_EXCEPTION =>
      val r = ConflictException
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AccessDeniedException
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.ACCESS_DENIED_EXCEPTION
  }
  case object InternalServerException
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.INTERNAL_SERVER_EXCEPTION
  }
  case object ValidationException
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.VALIDATION_EXCEPTION
  }
  case object ResourceNotFoundException
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.RESOURCE_NOT_FOUND_EXCEPTION
  }
  case object MaxPayloadSizeExceeded
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.MAX_PAYLOAD_SIZE_EXCEEDED
  }
  case object ConflictException
      extends zio.aws.deadline.model.JobEntityErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobEntityErrorCode =
      software.amazon.awssdk.services.deadline.model.JobEntityErrorCode.CONFLICT_EXCEPTION
  }
}
