package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait JobLifecycleStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.JobLifecycleStatus
}
object JobLifecycleStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.JobLifecycleStatus
  ): zio.aws.deadline.model.JobLifecycleStatus = value match {
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPLOAD_IN_PROGRESS =>
      val r = UPLOAD_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPLOAD_FAILED =>
      val r = UPLOAD_FAILED
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPDATE_SUCCEEDED =>
      val r = UPDATE_SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.CREATE_FAILED
  }
  case object CREATE_COMPLETE
      extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.CREATE_COMPLETE
  }
  case object UPLOAD_IN_PROGRESS
      extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPLOAD_IN_PROGRESS
  }
  case object UPLOAD_FAILED extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPLOAD_FAILED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_FAILED extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPDATE_FAILED
  }
  case object UPDATE_SUCCEEDED
      extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.UPDATE_SUCCEEDED
  }
  case object ARCHIVED extends zio.aws.deadline.model.JobLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobLifecycleStatus =
      software.amazon.awssdk.services.deadline.model.JobLifecycleStatus.ARCHIVED
  }
}
