package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  IdentityStoreId,
  QueueId,
  FarmId,
  IdentityCenterPrincipalId,
  JobId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobMember(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    principalId: IdentityCenterPrincipalId,
    principalType: zio.aws.deadline.model.PrincipalType,
    identityStoreId: IdentityStoreId,
    membershipLevel: zio.aws.deadline.model.MembershipLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobMember = {
    import JobMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobMember
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .principalId(
        IdentityCenterPrincipalId.unwrap(principalId): java.lang.String
      )
      .principalType(principalType.unwrap)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .membershipLevel(membershipLevel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobMember.ReadOnly =
    zio.aws.deadline.model.JobMember.wrap(buildAwsValue())
}
object JobMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobMember =
      zio.aws.deadline.model.JobMember(
        farmId,
        queueId,
        jobId,
        principalId,
        principalType,
        identityStoreId,
        membershipLevel
      )
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def principalId: IdentityCenterPrincipalId
    def principalType: zio.aws.deadline.model.PrincipalType
    def identityStoreId: IdentityStoreId
    def membershipLevel: zio.aws.deadline.model.MembershipLevel
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getPrincipalId: ZIO[Any, Nothing, IdentityCenterPrincipalId] =
      ZIO.succeed(principalId)
    def getPrincipalType
        : ZIO[Any, Nothing, zio.aws.deadline.model.PrincipalType] =
      ZIO.succeed(principalType)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMembershipLevel
        : ZIO[Any, Nothing, zio.aws.deadline.model.MembershipLevel] =
      ZIO.succeed(membershipLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobMember
  ) extends zio.aws.deadline.model.JobMember.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val principalId: IdentityCenterPrincipalId =
      zio.aws.deadline.model.primitives
        .IdentityCenterPrincipalId(impl.principalId())
    override val principalType: zio.aws.deadline.model.PrincipalType =
      zio.aws.deadline.model.PrincipalType.wrap(impl.principalType())
    override val identityStoreId: IdentityStoreId =
      zio.aws.deadline.model.primitives.IdentityStoreId(impl.identityStoreId())
    override val membershipLevel: zio.aws.deadline.model.MembershipLevel =
      zio.aws.deadline.model.MembershipLevel.wrap(impl.membershipLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobMember
  ): zio.aws.deadline.model.JobMember.ReadOnly = new Wrapper(impl)
}
