package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  PathString,
  ParameterString,
  FloatString,
  IntString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobParameter(
    intValue: Optional[IntString] = Optional.Absent,
    floatValue: Optional[FloatString] = Optional.Absent,
    string: Optional[ParameterString] = Optional.Absent,
    path: Optional[PathString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobParameter = {
    import JobParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobParameter
      .builder()
      .optionallyWith(
        intValue.map(value => IntString.unwrap(value): java.lang.String)
      )(_.intValue)
      .optionallyWith(
        floatValue.map(value => FloatString.unwrap(value): java.lang.String)
      )(_.floatValue)
      .optionallyWith(
        string.map(value => ParameterString.unwrap(value): java.lang.String)
      )(_.string)
      .optionallyWith(
        path.map(value => PathString.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobParameter.ReadOnly =
    zio.aws.deadline.model.JobParameter.wrap(buildAwsValue())
}
object JobParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobParameter =
      zio.aws.deadline.model.JobParameter(
        intValue.map(value => value),
        floatValue.map(value => value),
        string.map(value => value),
        path.map(value => value)
      )
    def intValue: Optional[IntString]
    def floatValue: Optional[FloatString]
    def string: Optional[ParameterString]
    def path: Optional[PathString]
    def getIntValue: ZIO[Any, AwsError, IntString] =
      AwsError.unwrapOptionField("intValue", intValue)
    def getFloatValue: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("floatValue", floatValue)
    def getString: ZIO[Any, AwsError, ParameterString] =
      AwsError.unwrapOptionField("string", string)
    def getPath: ZIO[Any, AwsError, PathString] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobParameter
  ) extends zio.aws.deadline.model.JobParameter.ReadOnly {
    override val intValue: Optional[IntString] = zio.aws.core.internal
      .optionalFromNullable(impl.intValue())
      .map(value => zio.aws.deadline.model.primitives.IntString(value))
    override val floatValue: Optional[FloatString] = zio.aws.core.internal
      .optionalFromNullable(impl.floatValue())
      .map(value => zio.aws.deadline.model.primitives.FloatString(value))
    override val string: Optional[ParameterString] = zio.aws.core.internal
      .optionalFromNullable(impl.string())
      .map(value => zio.aws.deadline.model.primitives.ParameterString(value))
    override val path: Optional[PathString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.deadline.model.primitives.PathString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobParameter
  ): zio.aws.deadline.model.JobParameter.ReadOnly = new Wrapper(impl)
}
