package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobRunAsUser(
    posix: Optional[zio.aws.deadline.model.PosixUser] = Optional.Absent,
    windows: Optional[zio.aws.deadline.model.WindowsUser] = Optional.Absent,
    runAs: zio.aws.deadline.model.RunAs
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobRunAsUser = {
    import JobRunAsUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobRunAsUser
      .builder()
      .optionallyWith(posix.map(value => value.buildAwsValue()))(_.posix)
      .optionallyWith(windows.map(value => value.buildAwsValue()))(_.windows)
      .runAs(runAs.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobRunAsUser.ReadOnly =
    zio.aws.deadline.model.JobRunAsUser.wrap(buildAwsValue())
}
object JobRunAsUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobRunAsUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobRunAsUser =
      zio.aws.deadline.model.JobRunAsUser(
        posix.map(value => value.asEditable),
        windows.map(value => value.asEditable),
        runAs
      )
    def posix: Optional[zio.aws.deadline.model.PosixUser.ReadOnly]
    def windows: Optional[zio.aws.deadline.model.WindowsUser.ReadOnly]
    def runAs: zio.aws.deadline.model.RunAs
    def getPosix
        : ZIO[Any, AwsError, zio.aws.deadline.model.PosixUser.ReadOnly] =
      AwsError.unwrapOptionField("posix", posix)
    def getWindows
        : ZIO[Any, AwsError, zio.aws.deadline.model.WindowsUser.ReadOnly] =
      AwsError.unwrapOptionField("windows", windows)
    def getRunAs: ZIO[Any, Nothing, zio.aws.deadline.model.RunAs] =
      ZIO.succeed(runAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobRunAsUser
  ) extends zio.aws.deadline.model.JobRunAsUser.ReadOnly {
    override val posix: Optional[zio.aws.deadline.model.PosixUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posix())
        .map(value => zio.aws.deadline.model.PosixUser.wrap(value))
    override val windows
        : Optional[zio.aws.deadline.model.WindowsUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windows())
        .map(value => zio.aws.deadline.model.WindowsUser.wrap(value))
    override val runAs: zio.aws.deadline.model.RunAs =
      zio.aws.deadline.model.RunAs.wrap(impl.runAs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobRunAsUser
  ): zio.aws.deadline.model.JobRunAsUser.ReadOnly = new Wrapper(impl)
}
