package zio.aws.deadline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  MaxFailedTasksCount,
  CreatedAt,
  JobPriority,
  MaxRetriesPerTask,
  EndedAt,
  JobName,
  JobId,
  CreatedBy,
  StartedAt
}
import scala.jdk.CollectionConverters._
final case class JobSearchSummary(
    jobId: Optional[JobId] = Optional.Absent,
    queueId: Optional[QueueId] = Optional.Absent,
    name: Optional[JobName] = Optional.Absent,
    lifecycleStatus: Optional[zio.aws.deadline.model.JobLifecycleStatus] =
      Optional.Absent,
    lifecycleStatusMessage: Optional[String] = Optional.Absent,
    taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      Optional.Absent,
    targetTaskRunStatus: Optional[
      zio.aws.deadline.model.JobTargetTaskRunStatus
    ] = Optional.Absent,
    taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = Optional.Absent,
    priority: Optional[JobPriority] = Optional.Absent,
    maxFailedTasksCount: Optional[MaxFailedTasksCount] = Optional.Absent,
    maxRetriesPerTask: Optional[MaxRetriesPerTask] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    endedAt: Optional[EndedAt] = Optional.Absent,
    startedAt: Optional[StartedAt] = Optional.Absent,
    jobParameters: Optional[Map[String, zio.aws.deadline.model.JobParameter]] =
      Optional.Absent,
    sourceJobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.JobSearchSummary = {
    import JobSearchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.JobSearchSummary
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        name.map(value => JobName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(lifecycleStatus.map(value => value.unwrap))(
        _.lifecycleStatus
      )
      .optionallyWith(
        lifecycleStatusMessage.map(value => value: java.lang.String)
      )(_.lifecycleStatusMessage)
      .optionallyWith(taskRunStatus.map(value => value.unwrap))(_.taskRunStatus)
      .optionallyWith(targetTaskRunStatus.map(value => value.unwrap))(
        _.targetTaskRunStatus
      )
      .optionallyWith(
        taskRunStatusCounts.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: Integer)
            })
            .asJava
        )
      )(_.taskRunStatusCountsWithStrings)
      .optionallyWith(
        priority.map(value => JobPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        maxFailedTasksCount.map(value =>
          MaxFailedTasksCount.unwrap(value): Integer
        )
      )(_.maxFailedTasksCount)
      .optionallyWith(
        maxRetriesPerTask.map(value => MaxRetriesPerTask.unwrap(value): Integer)
      )(_.maxRetriesPerTask)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(endedAt.map(value => EndedAt.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(startedAt.map(value => StartedAt.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        jobParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.jobParameters)
      .optionallyWith(
        sourceJobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.sourceJobId)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.JobSearchSummary.ReadOnly =
    zio.aws.deadline.model.JobSearchSummary.wrap(buildAwsValue())
}
object JobSearchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.JobSearchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.JobSearchSummary =
      zio.aws.deadline.model.JobSearchSummary(
        jobId.map(value => value),
        queueId.map(value => value),
        name.map(value => value),
        lifecycleStatus.map(value => value),
        lifecycleStatusMessage.map(value => value),
        taskRunStatus.map(value => value),
        targetTaskRunStatus.map(value => value),
        taskRunStatusCounts.map(value => value),
        priority.map(value => value),
        maxFailedTasksCount.map(value => value),
        maxRetriesPerTask.map(value => value),
        createdBy.map(value => value),
        createdAt.map(value => value),
        endedAt.map(value => value),
        startedAt.map(value => value),
        jobParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        sourceJobId.map(value => value)
      )
    def jobId: Optional[JobId]
    def queueId: Optional[QueueId]
    def name: Optional[JobName]
    def lifecycleStatus: Optional[zio.aws.deadline.model.JobLifecycleStatus]
    def lifecycleStatusMessage: Optional[String]
    def taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus]
    def targetTaskRunStatus
        : Optional[zio.aws.deadline.model.JobTargetTaskRunStatus]
    def taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]]
    def priority: Optional[JobPriority]
    def maxFailedTasksCount: Optional[MaxFailedTasksCount]
    def maxRetriesPerTask: Optional[MaxRetriesPerTask]
    def createdBy: Optional[CreatedBy]
    def createdAt: Optional[CreatedAt]
    def endedAt: Optional[EndedAt]
    def startedAt: Optional[StartedAt]
    def jobParameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]]
    def sourceJobId: Optional[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("name", name)
    def getLifecycleStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobLifecycleStatus] =
      AwsError.unwrapOptionField("lifecycleStatus", lifecycleStatus)
    def getLifecycleStatusMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lifecycleStatusMessage", lifecycleStatusMessage)
    def getTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.TaskRunStatus] =
      AwsError.unwrapOptionField("taskRunStatus", taskRunStatus)
    def getTargetTaskRunStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobTargetTaskRunStatus] =
      AwsError.unwrapOptionField("targetTaskRunStatus", targetTaskRunStatus)
    def getTaskRunStatusCounts: ZIO[Any, AwsError, Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = AwsError.unwrapOptionField("taskRunStatusCounts", taskRunStatusCounts)
    def getPriority: ZIO[Any, AwsError, JobPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxFailedTasksCount: ZIO[Any, AwsError, MaxFailedTasksCount] =
      AwsError.unwrapOptionField("maxFailedTasksCount", maxFailedTasksCount)
    def getMaxRetriesPerTask: ZIO[Any, AwsError, MaxRetriesPerTask] =
      AwsError.unwrapOptionField("maxRetriesPerTask", maxRetriesPerTask)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEndedAt: ZIO[Any, AwsError, EndedAt] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getStartedAt: ZIO[Any, AwsError, StartedAt] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getJobParameters: ZIO[Any, AwsError, Map[
      String,
      zio.aws.deadline.model.JobParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("jobParameters", jobParameters)
    def getSourceJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("sourceJobId", sourceJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.JobSearchSummary
  ) extends zio.aws.deadline.model.JobSearchSummary.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.deadline.model.primitives.QueueId(value))
    override val name: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.deadline.model.primitives.JobName(value))
    override val lifecycleStatus
        : Optional[zio.aws.deadline.model.JobLifecycleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleStatus())
        .map(value => zio.aws.deadline.model.JobLifecycleStatus.wrap(value))
    override val lifecycleStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleStatusMessage())
        .map(value => value: String)
    override val taskRunStatus: Optional[zio.aws.deadline.model.TaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskRunStatus())
        .map(value => zio.aws.deadline.model.TaskRunStatus.wrap(value))
    override val targetTaskRunStatus
        : Optional[zio.aws.deadline.model.JobTargetTaskRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTaskRunStatus())
        .map(value => zio.aws.deadline.model.JobTargetTaskRunStatus.wrap(value))
    override val taskRunStatusCounts: Optional[Map[
      zio.aws.deadline.model.TaskRunStatus,
      zio.aws.deadline.model.primitives.Integer
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRunStatusCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.deadline.model.TaskRunStatus
              .wrap(key) -> (value: zio.aws.deadline.model.primitives.Integer)
          })
          .toMap
      )
    override val priority: Optional[JobPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.deadline.model.primitives.JobPriority(value))
    override val maxFailedTasksCount: Optional[MaxFailedTasksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxFailedTasksCount())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxFailedTasksCount(value)
        )
    override val maxRetriesPerTask: Optional[MaxRetriesPerTask] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRetriesPerTask())
        .map(value =>
          zio.aws.deadline.model.primitives.MaxRetriesPerTask(value)
        )
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.deadline.model.primitives.CreatedBy(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.deadline.model.primitives.CreatedAt(value))
    override val endedAt: Optional[EndedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.deadline.model.primitives.EndedAt(value))
    override val startedAt: Optional[StartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.deadline.model.primitives.StartedAt(value))
    override val jobParameters
        : Optional[Map[String, zio.aws.deadline.model.JobParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.deadline.model.JobParameter.wrap(value)
            })
            .toMap
        )
    override val sourceJobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceJobId())
      .map(value => zio.aws.deadline.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.JobSearchSummary
  ): zio.aws.deadline.model.JobSearchSummary.ReadOnly = new Wrapper(impl)
}
