package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait JobTargetTaskRunStatus {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus
}
object JobTargetTaskRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus
  ): zio.aws.deadline.model.JobTargetTaskRunStatus = value match {
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.READY
  }
  case object FAILED extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.SUCCEEDED
  }
  case object CANCELED extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.CANCELED
  }
  case object SUSPENDED extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.SUSPENDED
  }
  case object PENDING extends zio.aws.deadline.model.JobTargetTaskRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus =
      software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus.PENDING
  }
}
