package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait LicenseEndpointStatus {
  def unwrap
      : software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus
}
object LicenseEndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus
  ): zio.aws.deadline.model.LicenseEndpointStatus = value match {
    case software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.NOT_READY =>
      val r = NOT_READY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.LicenseEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus =
      software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.deadline.model.LicenseEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus =
      software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.CREATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.deadline.model.LicenseEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus =
      software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.DELETE_IN_PROGRESS
  }
  case object READY extends zio.aws.deadline.model.LicenseEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus =
      software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.READY
  }
  case object NOT_READY extends zio.aws.deadline.model.LicenseEndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus =
      software.amazon.awssdk.services.deadline.model.LicenseEndpointStatus.NOT_READY
  }
}
