package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  VpcId,
  StatusMessage,
  LicenseEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LicenseEndpointSummary(
    licenseEndpointId: Optional[LicenseEndpointId] = Optional.Absent,
    status: Optional[zio.aws.deadline.model.LicenseEndpointStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary = {
    import LicenseEndpointSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary
      .builder()
      .optionallyWith(
        licenseEndpointId.map(value =>
          LicenseEndpointId.unwrap(value): java.lang.String
        )
      )(_.licenseEndpointId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly =
    zio.aws.deadline.model.LicenseEndpointSummary.wrap(buildAwsValue())
}
object LicenseEndpointSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.LicenseEndpointSummary =
      zio.aws.deadline.model.LicenseEndpointSummary(
        licenseEndpointId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        vpcId.map(value => value)
      )
    def licenseEndpointId: Optional[LicenseEndpointId]
    def status: Optional[zio.aws.deadline.model.LicenseEndpointStatus]
    def statusMessage: Optional[StatusMessage]
    def vpcId: Optional[VpcId]
    def getLicenseEndpointId: ZIO[Any, AwsError, LicenseEndpointId] =
      AwsError.unwrapOptionField("licenseEndpointId", licenseEndpointId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.deadline.model.LicenseEndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary
  ) extends zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly {
    override val licenseEndpointId: Optional[LicenseEndpointId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseEndpointId())
        .map(value =>
          zio.aws.deadline.model.primitives.LicenseEndpointId(value)
        )
    override val status
        : Optional[zio.aws.deadline.model.LicenseEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.deadline.model.LicenseEndpointStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.deadline.model.primitives.StatusMessage(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.deadline.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary
  ): zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly = new Wrapper(impl)
}
