package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAvailableMeteredProductsResponse(
    meteredProducts: Iterable[zio.aws.deadline.model.MeteredProductSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse = {
    import ListAvailableMeteredProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse
      .builder()
      .meteredProducts(meteredProducts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly =
    zio.aws.deadline.model.ListAvailableMeteredProductsResponse
      .wrap(buildAwsValue())
}
object ListAvailableMeteredProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.ListAvailableMeteredProductsResponse =
      zio.aws.deadline.model.ListAvailableMeteredProductsResponse(
        meteredProducts.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def meteredProducts
        : List[zio.aws.deadline.model.MeteredProductSummary.ReadOnly]
    def nextToken: Optional[String]
    def getMeteredProducts: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.MeteredProductSummary.ReadOnly
    ]] = ZIO.succeed(meteredProducts)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse
  ) extends zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly {
    override val meteredProducts
        : List[zio.aws.deadline.model.MeteredProductSummary.ReadOnly] = impl
      .meteredProducts()
      .asScala
      .map { item =>
        zio.aws.deadline.model.MeteredProductSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListAvailableMeteredProductsResponse
  ): zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly =
    new Wrapper(impl)
}
