package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, FarmId}
import scala.jdk.CollectionConverters._
final case class ListBudgetsRequest(
    nextToken: Optional[String] = Optional.Absent,
    farmId: FarmId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    status: Optional[zio.aws.deadline.model.BudgetStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListBudgetsRequest = {
    import ListBudgetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListBudgetsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListBudgetsRequest.ReadOnly =
    zio.aws.deadline.model.ListBudgetsRequest.wrap(buildAwsValue())
}
object ListBudgetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListBudgetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListBudgetsRequest =
      zio.aws.deadline.model.ListBudgetsRequest(
        nextToken.map(value => value),
        farmId,
        maxResults.map(value => value),
        status.map(value => value)
      )
    def nextToken: Optional[String]
    def farmId: FarmId
    def maxResults: Optional[MaxResults]
    def status: Optional[zio.aws.deadline.model.BudgetStatus]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[Any, AwsError, zio.aws.deadline.model.BudgetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListBudgetsRequest
  ) extends zio.aws.deadline.model.ListBudgetsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
    override val status: Optional[zio.aws.deadline.model.BudgetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.deadline.model.BudgetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListBudgetsRequest
  ): zio.aws.deadline.model.ListBudgetsRequest.ReadOnly = new Wrapper(impl)
}
