package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBudgetsResponse(
    nextToken: Optional[String] = Optional.Absent,
    budgets: Iterable[zio.aws.deadline.model.BudgetSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListBudgetsResponse = {
    import ListBudgetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListBudgetsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .budgets(budgets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListBudgetsResponse.ReadOnly =
    zio.aws.deadline.model.ListBudgetsResponse.wrap(buildAwsValue())
}
object ListBudgetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListBudgetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListBudgetsResponse =
      zio.aws.deadline.model.ListBudgetsResponse(
        nextToken.map(value => value),
        budgets.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def budgets: List[zio.aws.deadline.model.BudgetSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBudgets: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.BudgetSummary.ReadOnly
    ]] = ZIO.succeed(budgets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListBudgetsResponse
  ) extends zio.aws.deadline.model.ListBudgetsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val budgets: List[zio.aws.deadline.model.BudgetSummary.ReadOnly] =
      impl
        .budgets()
        .asScala
        .map { item =>
          zio.aws.deadline.model.BudgetSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListBudgetsResponse
  ): zio.aws.deadline.model.ListBudgetsResponse.ReadOnly = new Wrapper(impl)
}
