package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, FarmId}
import scala.jdk.CollectionConverters._
final case class ListFarmMembersRequest(
    farmId: FarmId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest = {
    import ListFarmMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListFarmMembersRequest.ReadOnly =
    zio.aws.deadline.model.ListFarmMembersRequest.wrap(buildAwsValue())
}
object ListFarmMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListFarmMembersRequest =
      zio.aws.deadline.model.ListFarmMembersRequest(
        farmId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def farmId: FarmId
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest
  ) extends zio.aws.deadline.model.ListFarmMembersRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest
  ): zio.aws.deadline.model.ListFarmMembersRequest.ReadOnly = new Wrapper(impl)
}
