package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFarmMembersResponse(
    members: Iterable[zio.aws.deadline.model.FarmMember],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse = {
    import ListFarmMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse
      .builder()
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly =
    zio.aws.deadline.model.ListFarmMembersResponse.wrap(buildAwsValue())
}
object ListFarmMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListFarmMembersResponse =
      zio.aws.deadline.model.ListFarmMembersResponse(
        members.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def members: List[zio.aws.deadline.model.FarmMember.ReadOnly]
    def nextToken: Optional[String]
    def getMembers
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.FarmMember.ReadOnly]] =
      ZIO.succeed(members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse
  ) extends zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly {
    override val members: List[zio.aws.deadline.model.FarmMember.ReadOnly] =
      impl
        .members()
        .asScala
        .map { item =>
          zio.aws.deadline.model.FarmMember.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse
  ): zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly = new Wrapper(impl)
}
