package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, IdentityCenterPrincipalId}
import scala.jdk.CollectionConverters._
final case class ListFarmsRequest(
    nextToken: Optional[String] = Optional.Absent,
    principalId: Optional[IdentityCenterPrincipalId] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListFarmsRequest = {
    import ListFarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListFarmsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        principalId.map(value =>
          IdentityCenterPrincipalId.unwrap(value): java.lang.String
        )
      )(_.principalId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListFarmsRequest.ReadOnly =
    zio.aws.deadline.model.ListFarmsRequest.wrap(buildAwsValue())
}
object ListFarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListFarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListFarmsRequest =
      zio.aws.deadline.model.ListFarmsRequest(
        nextToken.map(value => value),
        principalId.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def principalId: Optional[IdentityCenterPrincipalId]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrincipalId: ZIO[Any, AwsError, IdentityCenterPrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmsRequest
  ) extends zio.aws.deadline.model.ListFarmsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val principalId: Optional[IdentityCenterPrincipalId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalId())
        .map(value =>
          zio.aws.deadline.model.primitives.IdentityCenterPrincipalId(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmsRequest
  ): zio.aws.deadline.model.ListFarmsRequest.ReadOnly = new Wrapper(impl)
}
