package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFarmsResponse(
    nextToken: Optional[String] = Optional.Absent,
    farms: Iterable[zio.aws.deadline.model.FarmSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListFarmsResponse = {
    import ListFarmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListFarmsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .farms(farms.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListFarmsResponse.ReadOnly =
    zio.aws.deadline.model.ListFarmsResponse.wrap(buildAwsValue())
}
object ListFarmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListFarmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListFarmsResponse =
      zio.aws.deadline.model.ListFarmsResponse(
        nextToken.map(value => value),
        farms.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def farms: List[zio.aws.deadline.model.FarmSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFarms
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.FarmSummary.ReadOnly]] =
      ZIO.succeed(farms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmsResponse
  ) extends zio.aws.deadline.model.ListFarmsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val farms: List[zio.aws.deadline.model.FarmSummary.ReadOnly] = impl
      .farms()
      .asScala
      .map { item =>
        zio.aws.deadline.model.FarmSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListFarmsResponse
  ): zio.aws.deadline.model.ListFarmsResponse.ReadOnly = new Wrapper(impl)
}
