package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, FleetId, FarmId}
import scala.jdk.CollectionConverters._
final case class ListFleetMembersRequest(
    farmId: FarmId,
    fleetId: FleetId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest = {
    import ListFleetMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListFleetMembersRequest.ReadOnly =
    zio.aws.deadline.model.ListFleetMembersRequest.wrap(buildAwsValue())
}
object ListFleetMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListFleetMembersRequest =
      zio.aws.deadline.model.ListFleetMembersRequest(
        farmId,
        fleetId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def farmId: FarmId
    def fleetId: FleetId
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest
  ) extends zio.aws.deadline.model.ListFleetMembersRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListFleetMembersRequest
  ): zio.aws.deadline.model.ListFleetMembersRequest.ReadOnly = new Wrapper(impl)
}
