package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFleetMembersResponse(
    members: Iterable[zio.aws.deadline.model.FleetMember],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse = {
    import ListFleetMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse
      .builder()
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly =
    zio.aws.deadline.model.ListFleetMembersResponse.wrap(buildAwsValue())
}
object ListFleetMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListFleetMembersResponse =
      zio.aws.deadline.model.ListFleetMembersResponse(
        members.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def members: List[zio.aws.deadline.model.FleetMember.ReadOnly]
    def nextToken: Optional[String]
    def getMembers
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.FleetMember.ReadOnly]] =
      ZIO.succeed(members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse
  ) extends zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly {
    override val members: List[zio.aws.deadline.model.FleetMember.ReadOnly] =
      impl
        .members()
        .asScala
        .map { item =>
          zio.aws.deadline.model.FleetMember.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListFleetMembersResponse
  ): zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
