package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJobMembersResponse(
    members: Iterable[zio.aws.deadline.model.JobMember],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListJobMembersResponse = {
    import ListJobMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListJobMembersResponse
      .builder()
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListJobMembersResponse.ReadOnly =
    zio.aws.deadline.model.ListJobMembersResponse.wrap(buildAwsValue())
}
object ListJobMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListJobMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListJobMembersResponse =
      zio.aws.deadline.model.ListJobMembersResponse(
        members.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def members: List[zio.aws.deadline.model.JobMember.ReadOnly]
    def nextToken: Optional[String]
    def getMembers
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.JobMember.ReadOnly]] =
      ZIO.succeed(members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListJobMembersResponse
  ) extends zio.aws.deadline.model.ListJobMembersResponse.ReadOnly {
    override val members: List[zio.aws.deadline.model.JobMember.ReadOnly] = impl
      .members()
      .asScala
      .map { item =>
        zio.aws.deadline.model.JobMember.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListJobMembersResponse
  ): zio.aws.deadline.model.ListJobMembersResponse.ReadOnly = new Wrapper(impl)
}
