package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJobParameterDefinitionsResponse(
    jobParameterDefinitions: Iterable[
      zio.aws.deadline.model.JobParameterDefinition
    ],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse = {
    import ListJobParameterDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse
      .builder()
      .jobParameterDefinitions(jobParameterDefinitions.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly =
    zio.aws.deadline.model.ListJobParameterDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListJobParameterDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListJobParameterDefinitionsResponse =
      zio.aws.deadline.model.ListJobParameterDefinitionsResponse(
        jobParameterDefinitions,
        nextToken.map(value => value)
      )
    def jobParameterDefinitions
        : List[software.amazon.awssdk.core.document.Document]
    def nextToken: Optional[String]
    def getJobParameterDefinitions: ZIO[Any, Nothing, List[
      software.amazon.awssdk.core.document.Document
    ]] = ZIO.succeed(jobParameterDefinitions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse
  ) extends zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly {
    override val jobParameterDefinitions
        : List[software.amazon.awssdk.core.document.Document] =
      impl.jobParameterDefinitions().asScala.toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse
  ): zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
