package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  MaxResults,
  QueueId,
  IdentityCenterPrincipalId,
  FarmId
}
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    farmId: FarmId,
    principalId: Optional[IdentityCenterPrincipalId] = Optional.Absent,
    queueId: QueueId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListJobsRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .optionallyWith(
        principalId.map(value =>
          IdentityCenterPrincipalId.unwrap(value): java.lang.String
        )
      )(_.principalId)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListJobsRequest.ReadOnly =
    zio.aws.deadline.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListJobsRequest =
      zio.aws.deadline.model.ListJobsRequest(
        farmId,
        principalId.map(value => value),
        queueId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def farmId: FarmId
    def principalId: Optional[IdentityCenterPrincipalId]
    def queueId: QueueId
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getPrincipalId: ZIO[Any, AwsError, IdentityCenterPrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListJobsRequest
  ) extends zio.aws.deadline.model.ListJobsRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val principalId: Optional[IdentityCenterPrincipalId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalId())
        .map(value =>
          zio.aws.deadline.model.primitives.IdentityCenterPrincipalId(value)
        )
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListJobsRequest
  ): zio.aws.deadline.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
