package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJobsResponse(
    jobs: Iterable[zio.aws.deadline.model.JobSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListJobsResponse
      .builder()
      .jobs(jobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListJobsResponse.ReadOnly =
    zio.aws.deadline.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListJobsResponse =
      zio.aws.deadline.model.ListJobsResponse(
        jobs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobs: List[zio.aws.deadline.model.JobSummary.ReadOnly]
    def nextToken: Optional[String]
    def getJobs
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.JobSummary.ReadOnly]] =
      ZIO.succeed(jobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListJobsResponse
  ) extends zio.aws.deadline.model.ListJobsResponse.ReadOnly {
    override val jobs: List[zio.aws.deadline.model.JobSummary.ReadOnly] = impl
      .jobs()
      .asScala
      .map { item =>
        zio.aws.deadline.model.JobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListJobsResponse
  ): zio.aws.deadline.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
