package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLicenseEndpointsResponse(
    licenseEndpoints: Iterable[zio.aws.deadline.model.LicenseEndpointSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse = {
    import ListLicenseEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse
      .builder()
      .licenseEndpoints(licenseEndpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly =
    zio.aws.deadline.model.ListLicenseEndpointsResponse.wrap(buildAwsValue())
}
object ListLicenseEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListLicenseEndpointsResponse =
      zio.aws.deadline.model.ListLicenseEndpointsResponse(
        licenseEndpoints.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def licenseEndpoints
        : List[zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly]
    def nextToken: Optional[String]
    def getLicenseEndpoints: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly
    ]] = ZIO.succeed(licenseEndpoints)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse
  ) extends zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly {
    override val licenseEndpoints
        : List[zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly] = impl
      .licenseEndpoints()
      .asScala
      .map { item =>
        zio.aws.deadline.model.LicenseEndpointSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse
  ): zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly = new Wrapper(
    impl
  )
}
