package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, LicenseEndpointId}
import scala.jdk.CollectionConverters._
final case class ListMeteredProductsRequest(
    licenseEndpointId: LicenseEndpointId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest = {
    import ListMeteredProductsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest
      .builder()
      .licenseEndpointId(
        LicenseEndpointId.unwrap(licenseEndpointId): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListMeteredProductsRequest.ReadOnly =
    zio.aws.deadline.model.ListMeteredProductsRequest.wrap(buildAwsValue())
}
object ListMeteredProductsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListMeteredProductsRequest =
      zio.aws.deadline.model.ListMeteredProductsRequest(
        licenseEndpointId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def licenseEndpointId: LicenseEndpointId
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getLicenseEndpointId: ZIO[Any, Nothing, LicenseEndpointId] =
      ZIO.succeed(licenseEndpointId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest
  ) extends zio.aws.deadline.model.ListMeteredProductsRequest.ReadOnly {
    override val licenseEndpointId: LicenseEndpointId =
      zio.aws.deadline.model.primitives
        .LicenseEndpointId(impl.licenseEndpointId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest
  ): zio.aws.deadline.model.ListMeteredProductsRequest.ReadOnly = new Wrapper(
    impl
  )
}
