package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMonitorsResponse(
    nextToken: Optional[String] = Optional.Absent,
    monitors: Iterable[zio.aws.deadline.model.MonitorSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListMonitorsResponse = {
    import ListMonitorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListMonitorsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .monitors(monitors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListMonitorsResponse.ReadOnly =
    zio.aws.deadline.model.ListMonitorsResponse.wrap(buildAwsValue())
}
object ListMonitorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListMonitorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListMonitorsResponse =
      zio.aws.deadline.model.ListMonitorsResponse(
        nextToken.map(value => value),
        monitors.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def monitors: List[zio.aws.deadline.model.MonitorSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMonitors: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.MonitorSummary.ReadOnly
    ]] = ZIO.succeed(monitors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListMonitorsResponse
  ) extends zio.aws.deadline.model.ListMonitorsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val monitors
        : List[zio.aws.deadline.model.MonitorSummary.ReadOnly] = impl
      .monitors()
      .asScala
      .map { item =>
        zio.aws.deadline.model.MonitorSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListMonitorsResponse
  ): zio.aws.deadline.model.ListMonitorsResponse.ReadOnly = new Wrapper(impl)
}
