package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListQueueEnvironmentsResponse(
    environments: Iterable[zio.aws.deadline.model.QueueEnvironmentSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse = {
    import ListQueueEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse
      .builder()
      .environments(environments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly =
    zio.aws.deadline.model.ListQueueEnvironmentsResponse.wrap(buildAwsValue())
}
object ListQueueEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListQueueEnvironmentsResponse =
      zio.aws.deadline.model.ListQueueEnvironmentsResponse(
        environments.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def environments
        : List[zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly]
    def nextToken: Optional[String]
    def getEnvironments: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly
    ]] = ZIO.succeed(environments)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse
  ) extends zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly {
    override val environments
        : List[zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly] = impl
      .environments()
      .asScala
      .map { item =>
        zio.aws.deadline.model.QueueEnvironmentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse
  ): zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
