package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{MaxResults, FleetId, QueueId, FarmId}
import scala.jdk.CollectionConverters._
final case class ListQueueFleetAssociationsRequest(
    farmId: FarmId,
    queueId: Optional[QueueId] = Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest = {
    import ListQueueFleetAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListQueueFleetAssociationsRequest.ReadOnly =
    zio.aws.deadline.model.ListQueueFleetAssociationsRequest
      .wrap(buildAwsValue())
}
object ListQueueFleetAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListQueueFleetAssociationsRequest =
      zio.aws.deadline.model.ListQueueFleetAssociationsRequest(
        farmId,
        queueId.map(value => value),
        fleetId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def farmId: FarmId
    def queueId: Optional[QueueId]
    def fleetId: Optional[FleetId]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest
  ) extends zio.aws.deadline.model.ListQueueFleetAssociationsRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.deadline.model.primitives.QueueId(value))
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.deadline.model.primitives.FleetId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest
  ): zio.aws.deadline.model.ListQueueFleetAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
