package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListQueueFleetAssociationsResponse(
    queueFleetAssociations: Iterable[
      zio.aws.deadline.model.QueueFleetAssociationSummary
    ],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse = {
    import ListQueueFleetAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse
      .builder()
      .queueFleetAssociations(queueFleetAssociations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly =
    zio.aws.deadline.model.ListQueueFleetAssociationsResponse
      .wrap(buildAwsValue())
}
object ListQueueFleetAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListQueueFleetAssociationsResponse =
      zio.aws.deadline.model.ListQueueFleetAssociationsResponse(
        queueFleetAssociations.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def queueFleetAssociations
        : List[zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly]
    def nextToken: Optional[String]
    def getQueueFleetAssociations: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly
    ]] = ZIO.succeed(queueFleetAssociations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse
  ) extends zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly {
    override val queueFleetAssociations
        : List[zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly] =
      impl
        .queueFleetAssociations()
        .asScala
        .map { item =>
          zio.aws.deadline.model.QueueFleetAssociationSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse
  ): zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
