package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListQueueMembersResponse(
    members: Iterable[zio.aws.deadline.model.QueueMember],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse = {
    import ListQueueMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse
      .builder()
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly =
    zio.aws.deadline.model.ListQueueMembersResponse.wrap(buildAwsValue())
}
object ListQueueMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListQueueMembersResponse =
      zio.aws.deadline.model.ListQueueMembersResponse(
        members.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def members: List[zio.aws.deadline.model.QueueMember.ReadOnly]
    def nextToken: Optional[String]
    def getMembers
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.QueueMember.ReadOnly]] =
      ZIO.succeed(members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse
  ) extends zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly {
    override val members: List[zio.aws.deadline.model.QueueMember.ReadOnly] =
      impl
        .members()
        .asScala
        .map { item =>
          zio.aws.deadline.model.QueueMember.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse
  ): zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
