package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  MaxResults,
  IdentityCenterPrincipalId,
  FarmId
}
import scala.jdk.CollectionConverters._
final case class ListQueuesRequest(
    farmId: FarmId,
    principalId: Optional[IdentityCenterPrincipalId] = Optional.Absent,
    status: Optional[zio.aws.deadline.model.QueueStatus] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListQueuesRequest = {
    import ListQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListQueuesRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .optionallyWith(
        principalId.map(value =>
          IdentityCenterPrincipalId.unwrap(value): java.lang.String
        )
      )(_.principalId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListQueuesRequest.ReadOnly =
    zio.aws.deadline.model.ListQueuesRequest.wrap(buildAwsValue())
}
object ListQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListQueuesRequest =
      zio.aws.deadline.model.ListQueuesRequest(
        farmId,
        principalId.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def farmId: FarmId
    def principalId: Optional[IdentityCenterPrincipalId]
    def status: Optional[zio.aws.deadline.model.QueueStatus]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getPrincipalId: ZIO[Any, AwsError, IdentityCenterPrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getStatus: ZIO[Any, AwsError, zio.aws.deadline.model.QueueStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListQueuesRequest
  ) extends zio.aws.deadline.model.ListQueuesRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val principalId: Optional[IdentityCenterPrincipalId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalId())
        .map(value =>
          zio.aws.deadline.model.primitives.IdentityCenterPrincipalId(value)
        )
    override val status: Optional[zio.aws.deadline.model.QueueStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.deadline.model.QueueStatus.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.deadline.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListQueuesRequest
  ): zio.aws.deadline.model.ListQueuesRequest.ReadOnly = new Wrapper(impl)
}
