package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListQueuesResponse(
    queues: Iterable[zio.aws.deadline.model.QueueSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListQueuesResponse = {
    import ListQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListQueuesResponse
      .builder()
      .queues(queues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListQueuesResponse.ReadOnly =
    zio.aws.deadline.model.ListQueuesResponse.wrap(buildAwsValue())
}
object ListQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListQueuesResponse =
      zio.aws.deadline.model.ListQueuesResponse(
        queues.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def queues: List[zio.aws.deadline.model.QueueSummary.ReadOnly]
    def nextToken: Optional[String]
    def getQueues: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.QueueSummary.ReadOnly
    ]] = ZIO.succeed(queues)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListQueuesResponse
  ) extends zio.aws.deadline.model.ListQueuesResponse.ReadOnly {
    override val queues: List[zio.aws.deadline.model.QueueSummary.ReadOnly] =
      impl
        .queues()
        .asScala
        .map { item =>
          zio.aws.deadline.model.QueueSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListQueuesResponse
  ): zio.aws.deadline.model.ListQueuesResponse.ReadOnly = new Wrapper(impl)
}
