package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSessionActionsResponse(
    sessionActions: Iterable[zio.aws.deadline.model.SessionActionSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse = {
    import ListSessionActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse
      .builder()
      .sessionActions(sessionActions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly =
    zio.aws.deadline.model.ListSessionActionsResponse.wrap(buildAwsValue())
}
object ListSessionActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListSessionActionsResponse =
      zio.aws.deadline.model.ListSessionActionsResponse(
        sessionActions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def sessionActions
        : List[zio.aws.deadline.model.SessionActionSummary.ReadOnly]
    def nextToken: Optional[String]
    def getSessionActions: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.SessionActionSummary.ReadOnly
    ]] = ZIO.succeed(sessionActions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse
  ) extends zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly {
    override val sessionActions
        : List[zio.aws.deadline.model.SessionActionSummary.ReadOnly] = impl
      .sessionActions()
      .asScala
      .map { item =>
        zio.aws.deadline.model.SessionActionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListSessionActionsResponse
  ): zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
