package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSessionsForWorkerResponse(
    sessions: Iterable[zio.aws.deadline.model.WorkerSessionSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse = {
    import ListSessionsForWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse
      .builder()
      .sessions(sessions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly =
    zio.aws.deadline.model.ListSessionsForWorkerResponse.wrap(buildAwsValue())
}
object ListSessionsForWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListSessionsForWorkerResponse =
      zio.aws.deadline.model.ListSessionsForWorkerResponse(
        sessions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def sessions: List[zio.aws.deadline.model.WorkerSessionSummary.ReadOnly]
    def nextToken: Optional[String]
    def getSessions: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.WorkerSessionSummary.ReadOnly
    ]] = ZIO.succeed(sessions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse
  ) extends zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly {
    override val sessions
        : List[zio.aws.deadline.model.WorkerSessionSummary.ReadOnly] = impl
      .sessions()
      .asScala
      .map { item =>
        zio.aws.deadline.model.WorkerSessionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListSessionsForWorkerResponse
  ): zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly =
    new Wrapper(impl)
}
