package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSessionsResponse(
    sessions: Iterable[zio.aws.deadline.model.SessionSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListSessionsResponse = {
    import ListSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListSessionsResponse
      .builder()
      .sessions(sessions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListSessionsResponse.ReadOnly =
    zio.aws.deadline.model.ListSessionsResponse.wrap(buildAwsValue())
}
object ListSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListSessionsResponse =
      zio.aws.deadline.model.ListSessionsResponse(
        sessions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def sessions: List[zio.aws.deadline.model.SessionSummary.ReadOnly]
    def nextToken: Optional[String]
    def getSessions: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.SessionSummary.ReadOnly
    ]] = ZIO.succeed(sessions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListSessionsResponse
  ) extends zio.aws.deadline.model.ListSessionsResponse.ReadOnly {
    override val sessions
        : List[zio.aws.deadline.model.SessionSummary.ReadOnly] = impl
      .sessions()
      .asScala
      .map { item =>
        zio.aws.deadline.model.SessionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListSessionsResponse
  ): zio.aws.deadline.model.ListSessionsResponse.ReadOnly = new Wrapper(impl)
}
