package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStepConsumersResponse(
    consumers: Iterable[zio.aws.deadline.model.StepConsumer],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse = {
    import ListStepConsumersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse
      .builder()
      .consumers(consumers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly =
    zio.aws.deadline.model.ListStepConsumersResponse.wrap(buildAwsValue())
}
object ListStepConsumersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListStepConsumersResponse =
      zio.aws.deadline.model.ListStepConsumersResponse(
        consumers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def consumers: List[zio.aws.deadline.model.StepConsumer.ReadOnly]
    def nextToken: Optional[String]
    def getConsumers: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StepConsumer.ReadOnly
    ]] = ZIO.succeed(consumers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse
  ) extends zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly {
    override val consumers: List[zio.aws.deadline.model.StepConsumer.ReadOnly] =
      impl
        .consumers()
        .asScala
        .map { item =>
          zio.aws.deadline.model.StepConsumer.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse
  ): zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly = new Wrapper(
    impl
  )
}
