package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.{
  QueueId,
  FarmId,
  StepId,
  ListStepDependenciesRequestMaxResultsInteger,
  JobId
}
import scala.jdk.CollectionConverters._
final case class ListStepDependenciesRequest(
    farmId: FarmId,
    queueId: QueueId,
    jobId: JobId,
    stepId: StepId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListStepDependenciesRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest = {
    import ListStepDependenciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          ListStepDependenciesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListStepDependenciesRequest.ReadOnly =
    zio.aws.deadline.model.ListStepDependenciesRequest.wrap(buildAwsValue())
}
object ListStepDependenciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListStepDependenciesRequest =
      zio.aws.deadline.model.ListStepDependenciesRequest(
        farmId,
        queueId,
        jobId,
        stepId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def farmId: FarmId
    def queueId: QueueId
    def jobId: JobId
    def stepId: StepId
    def nextToken: Optional[String]
    def maxResults: Optional[ListStepDependenciesRequestMaxResultsInteger]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListStepDependenciesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest
  ) extends zio.aws.deadline.model.ListStepDependenciesRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[ListStepDependenciesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.deadline.model.primitives
            .ListStepDependenciesRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListStepDependenciesRequest
  ): zio.aws.deadline.model.ListStepDependenciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
