package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStepDependenciesResponse(
    dependencies: Iterable[zio.aws.deadline.model.StepDependency],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse = {
    import ListStepDependenciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse
      .builder()
      .dependencies(dependencies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly =
    zio.aws.deadline.model.ListStepDependenciesResponse.wrap(buildAwsValue())
}
object ListStepDependenciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListStepDependenciesResponse =
      zio.aws.deadline.model.ListStepDependenciesResponse(
        dependencies.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def dependencies: List[zio.aws.deadline.model.StepDependency.ReadOnly]
    def nextToken: Optional[String]
    def getDependencies: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StepDependency.ReadOnly
    ]] = ZIO.succeed(dependencies)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse
  ) extends zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly {
    override val dependencies
        : List[zio.aws.deadline.model.StepDependency.ReadOnly] = impl
      .dependencies()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StepDependency.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListStepDependenciesResponse
  ): zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
