package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStepsResponse(
    steps: Iterable[zio.aws.deadline.model.StepSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListStepsResponse = {
    import ListStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListStepsResponse
      .builder()
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListStepsResponse.ReadOnly =
    zio.aws.deadline.model.ListStepsResponse.wrap(buildAwsValue())
}
object ListStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListStepsResponse =
      zio.aws.deadline.model.ListStepsResponse(
        steps.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def steps: List[zio.aws.deadline.model.StepSummary.ReadOnly]
    def nextToken: Optional[String]
    def getSteps
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.StepSummary.ReadOnly]] =
      ZIO.succeed(steps)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListStepsResponse
  ) extends zio.aws.deadline.model.ListStepsResponse.ReadOnly {
    override val steps: List[zio.aws.deadline.model.StepSummary.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StepSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListStepsResponse
  ): zio.aws.deadline.model.ListStepsResponse.ReadOnly = new Wrapper(impl)
}
