package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStorageProfilesForQueueResponse(
    storageProfiles: Iterable[zio.aws.deadline.model.StorageProfileSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse = {
    import ListStorageProfilesForQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse
      .builder()
      .storageProfiles(storageProfiles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly =
    zio.aws.deadline.model.ListStorageProfilesForQueueResponse
      .wrap(buildAwsValue())
}
object ListStorageProfilesForQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListStorageProfilesForQueueResponse =
      zio.aws.deadline.model.ListStorageProfilesForQueueResponse(
        storageProfiles.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def storageProfiles
        : List[zio.aws.deadline.model.StorageProfileSummary.ReadOnly]
    def nextToken: Optional[String]
    def getStorageProfiles: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.StorageProfileSummary.ReadOnly
    ]] = ZIO.succeed(storageProfiles)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse
  ) extends zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly {
    override val storageProfiles
        : List[zio.aws.deadline.model.StorageProfileSummary.ReadOnly] = impl
      .storageProfiles()
      .asScala
      .map { item =>
        zio.aws.deadline.model.StorageProfileSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse
  ): zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly =
    new Wrapper(impl)
}
