package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTasksResponse(
    tasks: Iterable[zio.aws.deadline.model.TaskSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListTasksResponse = {
    import ListTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListTasksResponse
      .builder()
      .tasks(tasks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListTasksResponse.ReadOnly =
    zio.aws.deadline.model.ListTasksResponse.wrap(buildAwsValue())
}
object ListTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListTasksResponse =
      zio.aws.deadline.model.ListTasksResponse(
        tasks.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def tasks: List[zio.aws.deadline.model.TaskSummary.ReadOnly]
    def nextToken: Optional[String]
    def getTasks
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.TaskSummary.ReadOnly]] =
      ZIO.succeed(tasks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListTasksResponse
  ) extends zio.aws.deadline.model.ListTasksResponse.ReadOnly {
    override val tasks: List[zio.aws.deadline.model.TaskSummary.ReadOnly] = impl
      .tasks()
      .asScala
      .map { item =>
        zio.aws.deadline.model.TaskSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListTasksResponse
  ): zio.aws.deadline.model.ListTasksResponse.ReadOnly = new Wrapper(impl)
}
