package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkersResponse(
    nextToken: Optional[String] = Optional.Absent,
    workers: Iterable[zio.aws.deadline.model.WorkerSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ListWorkersResponse = {
    import ListWorkersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ListWorkersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .workers(workers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ListWorkersResponse.ReadOnly =
    zio.aws.deadline.model.ListWorkersResponse.wrap(buildAwsValue())
}
object ListWorkersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ListWorkersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ListWorkersResponse =
      zio.aws.deadline.model.ListWorkersResponse(
        nextToken.map(value => value),
        workers.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def workers: List[zio.aws.deadline.model.WorkerSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkers: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.WorkerSummary.ReadOnly
    ]] = ZIO.succeed(workers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ListWorkersResponse
  ) extends zio.aws.deadline.model.ListWorkersResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val workers: List[zio.aws.deadline.model.WorkerSummary.ReadOnly] =
      impl
        .workers()
        .asScala
        .map { item =>
          zio.aws.deadline.model.WorkerSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ListWorkersResponse
  ): zio.aws.deadline.model.ListWorkersResponse.ReadOnly = new Wrapper(impl)
}
