package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{LogError, LogDriver}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogConfiguration(
    logDriver: LogDriver,
    options: Optional[Map[String, String]] = Optional.Absent,
    parameters: Optional[Map[String, String]] = Optional.Absent,
    error: Optional[LogError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.LogConfiguration = {
    import LogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.LogConfiguration
      .builder()
      .logDriver(LogDriver.unwrap(logDriver): java.lang.String)
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        error.map(value => LogError.unwrap(value): java.lang.String)
      )(_.error)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.LogConfiguration.ReadOnly =
    zio.aws.deadline.model.LogConfiguration.wrap(buildAwsValue())
}
object LogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.LogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.LogConfiguration =
      zio.aws.deadline.model.LogConfiguration(
        logDriver,
        options.map(value => value),
        parameters.map(value => value),
        error.map(value => value)
      )
    def logDriver: LogDriver
    def options: Optional[Map[String, String]]
    def parameters: Optional[Map[String, String]]
    def error: Optional[LogError]
    def getLogDriver: ZIO[Any, Nothing, LogDriver] = ZIO.succeed(logDriver)
    def getOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("options", options)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getError: ZIO[Any, AwsError, LogError] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.LogConfiguration
  ) extends zio.aws.deadline.model.LogConfiguration.ReadOnly {
    override val logDriver: LogDriver =
      zio.aws.deadline.model.primitives.LogDriver(impl.logDriver())
    override val options: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val parameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val error: Optional[LogError] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.deadline.model.primitives.LogError(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.LogConfiguration
  ): zio.aws.deadline.model.LogConfiguration.ReadOnly = new Wrapper(impl)
}
