package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait LogicalOperator {
  def unwrap: software.amazon.awssdk.services.deadline.model.LogicalOperator
}
object LogicalOperator {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.LogicalOperator
  ): zio.aws.deadline.model.LogicalOperator = value match {
    case software.amazon.awssdk.services.deadline.model.LogicalOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.LogicalOperator.AND =>
      val r = AND
      r
    case software.amazon.awssdk.services.deadline.model.LogicalOperator.OR =>
      val r = OR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.LogicalOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LogicalOperator =
      software.amazon.awssdk.services.deadline.model.LogicalOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object AND extends zio.aws.deadline.model.LogicalOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LogicalOperator =
      software.amazon.awssdk.services.deadline.model.LogicalOperator.AND
  }
  case object OR extends zio.aws.deadline.model.LogicalOperator {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.LogicalOperator =
      software.amazon.awssdk.services.deadline.model.LogicalOperator.OR
  }
}
