package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  OutputRelativeDirectoriesListMemberString,
  ManifestPropertiesRootPathString,
  FileSystemLocationName,
  ManifestPropertiesInputManifestPathString,
  ManifestPropertiesInputManifestHashString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManifestProperties(
    fileSystemLocationName: Optional[FileSystemLocationName] = Optional.Absent,
    rootPath: ManifestPropertiesRootPathString,
    rootPathFormat: zio.aws.deadline.model.PathFormat,
    outputRelativeDirectories: Optional[
      Iterable[OutputRelativeDirectoriesListMemberString]
    ] = Optional.Absent,
    inputManifestPath: Optional[ManifestPropertiesInputManifestPathString] =
      Optional.Absent,
    inputManifestHash: Optional[ManifestPropertiesInputManifestHashString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.ManifestProperties = {
    import ManifestProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.ManifestProperties
      .builder()
      .optionallyWith(
        fileSystemLocationName.map(value =>
          FileSystemLocationName.unwrap(value): java.lang.String
        )
      )(_.fileSystemLocationName)
      .rootPath(
        ManifestPropertiesRootPathString.unwrap(rootPath): java.lang.String
      )
      .rootPathFormat(rootPathFormat.unwrap)
      .optionallyWith(
        outputRelativeDirectories.map(value =>
          value.map { item =>
            OutputRelativeDirectoriesListMemberString.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.outputRelativeDirectories)
      .optionallyWith(
        inputManifestPath.map(value =>
          ManifestPropertiesInputManifestPathString.unwrap(
            value
          ): java.lang.String
        )
      )(_.inputManifestPath)
      .optionallyWith(
        inputManifestHash.map(value =>
          ManifestPropertiesInputManifestHashString.unwrap(
            value
          ): java.lang.String
        )
      )(_.inputManifestHash)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.ManifestProperties.ReadOnly =
    zio.aws.deadline.model.ManifestProperties.wrap(buildAwsValue())
}
object ManifestProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.ManifestProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.ManifestProperties =
      zio.aws.deadline.model.ManifestProperties(
        fileSystemLocationName.map(value => value),
        rootPath,
        rootPathFormat,
        outputRelativeDirectories.map(value => value),
        inputManifestPath.map(value => value),
        inputManifestHash.map(value => value)
      )
    def fileSystemLocationName: Optional[FileSystemLocationName]
    def rootPath: ManifestPropertiesRootPathString
    def rootPathFormat: zio.aws.deadline.model.PathFormat
    def outputRelativeDirectories
        : Optional[List[OutputRelativeDirectoriesListMemberString]]
    def inputManifestPath: Optional[ManifestPropertiesInputManifestPathString]
    def inputManifestHash: Optional[ManifestPropertiesInputManifestHashString]
    def getFileSystemLocationName: ZIO[Any, AwsError, FileSystemLocationName] =
      AwsError.unwrapOptionField(
        "fileSystemLocationName",
        fileSystemLocationName
      )
    def getRootPath: ZIO[Any, Nothing, ManifestPropertiesRootPathString] =
      ZIO.succeed(rootPath)
    def getRootPathFormat
        : ZIO[Any, Nothing, zio.aws.deadline.model.PathFormat] =
      ZIO.succeed(rootPathFormat)
    def getOutputRelativeDirectories
        : ZIO[Any, AwsError, List[OutputRelativeDirectoriesListMemberString]] =
      AwsError.unwrapOptionField(
        "outputRelativeDirectories",
        outputRelativeDirectories
      )
    def getInputManifestPath
        : ZIO[Any, AwsError, ManifestPropertiesInputManifestPathString] =
      AwsError.unwrapOptionField("inputManifestPath", inputManifestPath)
    def getInputManifestHash
        : ZIO[Any, AwsError, ManifestPropertiesInputManifestHashString] =
      AwsError.unwrapOptionField("inputManifestHash", inputManifestHash)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.ManifestProperties
  ) extends zio.aws.deadline.model.ManifestProperties.ReadOnly {
    override val fileSystemLocationName: Optional[FileSystemLocationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemLocationName())
        .map(value =>
          zio.aws.deadline.model.primitives.FileSystemLocationName(value)
        )
    override val rootPath: ManifestPropertiesRootPathString =
      zio.aws.deadline.model.primitives
        .ManifestPropertiesRootPathString(impl.rootPath())
    override val rootPathFormat: zio.aws.deadline.model.PathFormat =
      zio.aws.deadline.model.PathFormat.wrap(impl.rootPathFormat())
    override val outputRelativeDirectories
        : Optional[List[OutputRelativeDirectoriesListMemberString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputRelativeDirectories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.deadline.model.primitives
              .OutputRelativeDirectoriesListMemberString(item)
          }.toList
        )
    override val inputManifestPath
        : Optional[ManifestPropertiesInputManifestPathString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputManifestPath())
        .map(value =>
          zio.aws.deadline.model.primitives
            .ManifestPropertiesInputManifestPathString(value)
        )
    override val inputManifestHash
        : Optional[ManifestPropertiesInputManifestHashString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputManifestHash())
        .map(value =>
          zio.aws.deadline.model.primitives
            .ManifestPropertiesInputManifestHashString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.ManifestProperties
  ): zio.aws.deadline.model.ManifestProperties.ReadOnly = new Wrapper(impl)
}
