package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait MembershipLevel {
  def unwrap: software.amazon.awssdk.services.deadline.model.MembershipLevel
}
object MembershipLevel {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.MembershipLevel
  ): zio.aws.deadline.model.MembershipLevel = value match {
    case software.amazon.awssdk.services.deadline.model.MembershipLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.MembershipLevel.VIEWER =>
      val r = VIEWER
      r
    case software.amazon.awssdk.services.deadline.model.MembershipLevel.CONTRIBUTOR =>
      val r = CONTRIBUTOR
      r
    case software.amazon.awssdk.services.deadline.model.MembershipLevel.OWNER =>
      val r = OWNER
      r
    case software.amazon.awssdk.services.deadline.model.MembershipLevel.MANAGER =>
      val r = MANAGER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.MembershipLevel {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.MembershipLevel =
      software.amazon.awssdk.services.deadline.model.MembershipLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object VIEWER extends zio.aws.deadline.model.MembershipLevel {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.MembershipLevel =
      software.amazon.awssdk.services.deadline.model.MembershipLevel.VIEWER
  }
  case object CONTRIBUTOR extends zio.aws.deadline.model.MembershipLevel {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.MembershipLevel =
      software.amazon.awssdk.services.deadline.model.MembershipLevel.CONTRIBUTOR
  }
  case object OWNER extends zio.aws.deadline.model.MembershipLevel {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.MembershipLevel =
      software.amazon.awssdk.services.deadline.model.MembershipLevel.OWNER
  }
  case object MANAGER extends zio.aws.deadline.model.MembershipLevel {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.MembershipLevel =
      software.amazon.awssdk.services.deadline.model.MembershipLevel.MANAGER
  }
}
