package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.MemoryAmountMiB
import scala.jdk.CollectionConverters._
final case class MemoryMiBRange(
    min: MemoryAmountMiB,
    max: Optional[MemoryAmountMiB] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.MemoryMiBRange = {
    import MemoryMiBRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.MemoryMiBRange
      .builder()
      .min(MemoryAmountMiB.unwrap(min): Integer)
      .optionallyWith(max.map(value => MemoryAmountMiB.unwrap(value): Integer))(
        _.max
      )
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.MemoryMiBRange.ReadOnly =
    zio.aws.deadline.model.MemoryMiBRange.wrap(buildAwsValue())
}
object MemoryMiBRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.MemoryMiBRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.MemoryMiBRange =
      zio.aws.deadline.model.MemoryMiBRange(min, max.map(value => value))
    def min: MemoryAmountMiB
    def max: Optional[MemoryAmountMiB]
    def getMin: ZIO[Any, Nothing, MemoryAmountMiB] = ZIO.succeed(min)
    def getMax: ZIO[Any, AwsError, MemoryAmountMiB] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.MemoryMiBRange
  ) extends zio.aws.deadline.model.MemoryMiBRange.ReadOnly {
    override val min: MemoryAmountMiB =
      zio.aws.deadline.model.primitives.MemoryAmountMiB(impl.min())
    override val max: Optional[MemoryAmountMiB] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => zio.aws.deadline.model.primitives.MemoryAmountMiB(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.MemoryMiBRange
  ): zio.aws.deadline.model.MemoryMiBRange.ReadOnly = new Wrapper(impl)
}
