package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  PortNumber,
  BoundedString,
  MeteredProductId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MeteredProductSummary(
    productId: MeteredProductId,
    family: BoundedString,
    vendor: BoundedString,
    port: PortNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.MeteredProductSummary = {
    import MeteredProductSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.MeteredProductSummary
      .builder()
      .productId(MeteredProductId.unwrap(productId): java.lang.String)
      .family(BoundedString.unwrap(family): java.lang.String)
      .vendor(BoundedString.unwrap(vendor): java.lang.String)
      .port(PortNumber.unwrap(port): Integer)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.MeteredProductSummary.ReadOnly =
    zio.aws.deadline.model.MeteredProductSummary.wrap(buildAwsValue())
}
object MeteredProductSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.MeteredProductSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.MeteredProductSummary =
      zio.aws.deadline.model.MeteredProductSummary(
        productId,
        family,
        vendor,
        port
      )
    def productId: MeteredProductId
    def family: BoundedString
    def vendor: BoundedString
    def port: PortNumber
    def getProductId: ZIO[Any, Nothing, MeteredProductId] =
      ZIO.succeed(productId)
    def getFamily: ZIO[Any, Nothing, BoundedString] = ZIO.succeed(family)
    def getVendor: ZIO[Any, Nothing, BoundedString] = ZIO.succeed(vendor)
    def getPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.MeteredProductSummary
  ) extends zio.aws.deadline.model.MeteredProductSummary.ReadOnly {
    override val productId: MeteredProductId =
      zio.aws.deadline.model.primitives.MeteredProductId(impl.productId())
    override val family: BoundedString =
      zio.aws.deadline.model.primitives.BoundedString(impl.family())
    override val vendor: BoundedString =
      zio.aws.deadline.model.primitives.BoundedString(impl.vendor())
    override val port: PortNumber =
      zio.aws.deadline.model.primitives.PortNumber(impl.port())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.MeteredProductSummary
  ): zio.aws.deadline.model.MeteredProductSummary.ReadOnly = new Wrapper(impl)
}
